from tkinter import *
from tkinter import font, messagebox
from RAMkill import memory_sorter
from time import sleep, time
from threading import Thread
from copy import deepcopy
from psutil import virtual_memory, cpu_percent
from subprocess import Popen, PIPE
from json import load, dump, JSONDecodeError
from ctypes import windll
actual_mem = []
selection = ""
whitemode = False
sel_setting = 0


def main_window():
    def option_window():
        def setting_opener():
            # open top level where we can change settings
            global sel_setting
            w_master = Toplevel(option)
            w_master.geometry(f"250x50+{option.geometry().split('+')[1]}+{option.geometry().split('+')[2]}")
            w_master.configure(bg=background)

            # if we want to change theme
            if sel_setting == 0:
                global whitemode
                w_master.title("change theme")
                w_master.grid_rowconfigure(0, weight=1)
                w_master.grid_columnconfigure(0, weight=1)

                # creating label that shows what theme is currently selected
                str_var = StringVar()
                if whitemode:
                    str_var.set("currently: light mode")
                else:
                    str_var.set("currently: dark mode")
                cur_theme = Label(w_master, textvariable=str_var, bg=background, fg=foreground, relief=SUNKEN)
                cur_theme.configure(font=("Segoe", 14))
                cur_theme.grid(row=0, column=0, sticky=NSEW, columnspan=2)

                def change_light():
                    # changing the values to light
                    global whitemode
                    if not whitemode:
                        whitemode = True
                        dark_but.configure(state=NORMAL)
                        light_button.configure(state=DISABLED)
                        str_var.set("currently: light mode")
                        messagebox.showinfo("pls restart", "For this setting to apply, please restart the program.")
                        level_raiser(option)
                        level_raiser(w_master)

                def change_dark():
                    # changing the values to dark
                    global whitemode
                    if whitemode:
                        whitemode = False
                        str_var.set("currently: dark mode")
                        dark_but.configure(state=DISABLED)
                        light_button.configure(state=NORMAL)
                        messagebox.showinfo("pls restart", "For this setting to apply, please restart the program.")
                        level_raiser(option)
                        level_raiser(w_master)

                # creating buttons that change the settings
                dark_but = Button(w_master, text="change to dark mode", bg=background, fg=foreground, bd=1)
                dark_but.configure(command=change_dark)
                dark_but.grid(row=1, column=0, sticky=NSEW)

                light_button = Button(w_master, text="change to light mode", bg=background, fg=foreground, bd=1)
                light_button.configure(command=change_light)
                light_button.grid(row=1, column=1, sticky=NSEW)
                if not whitemode:
                    dark_but.configure(state=DISABLED)
                else:
                    light_button.configure(state=DISABLED)

            w_master.mainloop()

        # creating settings Menu
        option = Toplevel(root)
        option.title("Settings")
        entries = 4
        option.geometry(f"300x300+{root.geometry().split('+')[1]}+{root.geometry().split('+')[2]}")
        option.configure(bg=background)
        option.grid_rowconfigure(0, weight=1)
        option.grid_columnconfigure(0, weight=1)
        buttons = 4

        # creating Options with list box
        setting_scroll = Scrollbar(option)
        setting_scroll.grid(column=buttons, row=0, sticky=NSEW, rowspan=2)

        setting_box = Listbox(option, yscrollcommand=setting_scroll.set, bg=background,
                              selectbackground="#4d409c")
        setting_box.configure(fg=foreground, height=entries, bd=0, font=st_font, highlightbackground="#e8e5ff",
                              activestyle="none")
        setting_scroll.configure(command=setting_box)
        setting_box.grid(column=0, row=0, sticky=NSEW, columnspan=buttons)

        # creating button for opening settings
        def button_creator():
            b = Button(option, text="open setting", bg=background, fg=foreground, bd=1, relief=RAISED)
            b.configure(command=setting_opener)
            b.grid(row=1, column=1, sticky=NSEW, ipadx=10)
        button_creator()

        # creating entries
        entries = ["display theme"]
        for i_ in entries:
            setting_box.insert(END, i_)

    def level_raiser(master):
        # raises level of gui to top
        if master == root:
            sleep(0.1)
        master.attributes("-topmost", 1)
        master.attributes("-topmost", 0)

    def closer():
        # saves settings
        f_ = open("taskgui_options.json", "w")
        dump([root.geometry(), whitemode, selection], f_)
        f_.close()
        root.destroy()

    def task_killer(task_list):
        # kills the selected tasks
        global actual_mem
        prev_delete = 0
        for i_ in task_list.curselection():
            sys_cmd = f"taskkill -F -pid {actual_mem[i_][2]}"
            output = str(Popen(sys_cmd, stdout=PIPE).communicate()[0])
            if len(output) > 3:
                label_list.delete(i_ - prev_delete)
                prev_delete += 1
                # print(output)
            else:
                messagebox.showwarning(title="Error", message=f"Task \"{actual_mem[i_][0]}\", PID {actual_mem[i_][2]}, was unable to be killed.")
            # print(sys_cmd)

    def selection_setter(sel):
        # checks what sorting selection has been made
        global selection
        selection = sel

    def list_maker():
        # gets list and puts it into list box
        start = time()
        global selection
        global actual_mem

        # if sort selection not selected set it to default Name
        if selection == "sort by":
            def_sel = "Name"
        else:
            def_sel = selection

        # actually getting list of processes and formatting to string with whitespaces
        print("updating list")
        mem_list = memory_sorter(sort=def_sel)
        actual_mem = deepcopy(mem_list)
        mem_list = list_stringer(mem_list)

        '''# deleting form listbox
        if label_list.size() > 0:
            for _ in range(label_list.size()):
                label_list.delete(0)'''

        # deleting from listbox if there are more old entries than new processes
        if len(mem_list) < label_list.size():
            for _ in range(len(mem_list), label_list.size()):
                label_list.delete(0)

        # building string and inserting in listbox
        led_zeros = "{:0" + str(len(str(len(mem_list) - 1))) + "d}"
        for r_, i_ in enumerate(mem_list):
            print_str = f"{led_zeros.format(r_)} | Name: {i_[0]} | Memory: {i_[1]}mb | PID: {i_[2]} |" \
                        f" Children: {i_[3]} | CPU: {i_[4]}irgendetwas idk"
            label_list.delete(r_)
            label_list.insert(r_, print_str)

        print(time() - start)

    def updater():
        # updates every x seconds
        global actual_mem
        r_ = 9
        spaces = space_adder(10)
        while True:
            r_ += 1
            if r_ == 10:
                Thread(target=list_maker, daemon=True).start()
                r_ = 0

            text.set(f"CPU: {cpu_percent()}%{spaces}Memory: {virtual_memory().percent}%{spaces}Processes: {len(actual_mem)}")
            sleep(update_time / 10)

    # loading settings
    global whitemode
    loaded = ["960x520+0+0", True, "sort by"]
    try:
        f = open("taskgui_options.json", "r")
        load_ed = load(f)
        f.close()
        for r, i in enumerate(load_ed):
            loaded[r] = i

    except (JSONDecodeError, FileNotFoundError):
        pass

    # defining how often to update
    update_time = 10

    # remembering what to sort by
    global selection
    selection = loaded[2]

    # defining colors
    whitemode = loaded[1]
    if not whitemode:
        background = "#303945"
        foreground = "#e8e5ff"
        hbg = "#233143"
    else:
        background = "#cbe3f0"
        foreground = "#163c50"
        hbg = "#9aceea"
    # listbox_bg = "#333045"

    # creating root
    root = Tk()
    root.configure(bg=background)
    root.title("TaskGUI")
    user = windll.user32
    screen = user.GetSystemMetrics(78), user.GetSystemMetrics(79)
    if int(loaded[0].split("+")[1]) > screen[0]:
        loaded[0] = loaded[0].split("+")[0]
    root.geometry(loaded[0])
    root.grid_rowconfigure(0, weight=1)
    root.grid_columnconfigure(0, weight=1)
    st_font = font.Font(family="DejaVu Sans Mono", size=12)

    # creating scrollbar
    scrollbar = Scrollbar(root)
    scrollbar.grid(column=5, row=0, sticky=NS, rowspan=2)

    # labels and buttons
    lab2 = Label(root, text=" ")
    lab2.grid(column=4, row=1, ipadx=0, ipady=0, sticky=NSEW)

    but1 = Button(root, text="kill task", bg=background, fg=foreground, padx=0, pady=0)
    but1.config(font=("Segoe", 18), highlightbackground="#e8e5ff")
    but1.grid(column=3, row=1, ipadx=20, ipady=0, sticky=NSEW, columnspan=2)

    # creating value label
    text = StringVar()
    values = Label(root, textvariable=text, font=("Segoe", 18), bg=background, fg=foreground)
    values.grid(column=0, row=1, ipadx=20, ipady=0, sticky=NSEW)

    # creating option menu for sorting
    option_list = ["Name", "Memory", "CPU", "PID", "Children"]
    variable = StringVar()
    variable.set(selection)
    sort_option = OptionMenu(root, variable, *option_list, command=selection_setter)
    sort_option.config(bg=background, bd=1, fg=foreground, font=("Segoe", 12), highlightbackground=hbg)
    sort_option.grid(column=2, row=1, ipadx=0, ipady=0, sticky=NS)

    # creating settings button
    settings_button = Button(root, text="settings", bg=background, fg=foreground, padx=0, pady=0)
    settings_button.config(font=("Segoe", 12), highlightbackground="#e8e5ff", command=option_window)
    settings_button.grid(column=1, row=1, ipadx=0, ipady=0, sticky=NS)

    # listbox
    label_list = Listbox(root, yscrollcommand=scrollbar.set, bg=background, selectmode=EXTENDED, selectbackground="#4d409c")
    label_list.configure(fg=foreground, height=21, bd=0, font=st_font, highlightbackground="#e8e5ff", activestyle="none")
    label_list.grid(row=0, sticky=NSEW, column=0, columnspan=5)
    scrollbar.configure(command=label_list.yview)
    but1.configure(command=lambda: task_killer(label_list))

    # starting program
    Thread(target=updater, daemon=True).start()
    Thread(target=level_raiser, daemon=True, args=(root, )).start()
    root.protocol("WM_DELETE_WINDOW", closer)
    root.mainloop()


def space_adder(spaces):
    done = ""
    for _ in range(spaces):
        done += " "
    return done


def list_stringer(task_list):
    # formatting list to strings
    task_str_list = []
    length_list = [0, 0, 0, 0, 0]
    for i in task_list:
        for r, t in enumerate(i):
            if len(str(t)) > length_list[r]:
                length_list[r] = len(str(t))

    for i in task_list:
        list_append = []
        for r, f, fr in zip(range(len(i)), i, length_list):
            f = str(f)
            if r != 0:
                appendum = f"{space_adder(fr - len(f))}{f}"
            else:
                appendum = f"{f}{space_adder(fr - len(f))}"
            list_append.append(appendum)
        task_str_list.append(list_append)

    return task_str_list


if __name__ == '__main__':
    main_window()
