from time import sleep
from threading import Thread
from subprocess import Popen, PIPE
from os import getpid, getppid
from time import time
try:
    from psutil import process_iter, virtual_memory, AccessDenied
except ModuleNotFoundError as err:
    input(f"{err} Psutil not installed. Please install psutil.")
    exit(1)

stop = False


def stop_input(q):
    global stop
    if q != "":
        if q.get() == "return":
            stop = True
            return


def sort_name(task):
    return task[0]


def sort_mem(task):
    return task[1]


def sort_pid(task):
    return task[2]


def sort_children(task):
    return task[3]


def sort_cpu(task):
    return task[4]


def memory_sorter(needed_tasks=False, document=False, sort=None):
    tasks = []
    start = time()
    processes = process_iter()
    for p in processes:
        children = 0
        cpu = p.cpu_percent()
        name = p.name()
        pid = p.pid
        try:
            memory = p.memory_full_info().uss / (1024 ** 2)
        except AccessDenied:
            memory = p.memory_info().vms / (1024 ** 2)
        memory = round(memory, 1)
        # print(name, "pid", pid, memory)

        # looking for children
        pparent = p.parent()
        if pparent is not None:
            if pparent.name() != "explorer.exe":
                children = 1

        tasks.append([name, memory, pid, children, cpu])

    # deleting children

    def sort_name_child(task):
        return task[0], task[3]

    tasks = sorted(tasks, key=sort_name_child)
    # print(f"{time() - start} process getter time")
    done_tasks = []
    last_name = ""
    last_addition = False
    total_mem = 0
    total_cpu = 0
    children_count = 1
    for r, i in enumerate(tasks):
        curr_name = i[0]
        # when the last name is the same as the current one delete child
        if curr_name == last_name:
            # print(curr_name)
            total_cpu += i[4]
            total_mem += i[1]
            last_addition = True
            children_count += 1
            done_tasks.append([])

        # when the last child is deleted, add memory, cpu and children to parent
        elif curr_name != last_name and last_addition:
            # print(r, children_count, done_tasks)
            done_tasks[r - children_count][1] = round(done_tasks[r - children_count][1] + total_mem, 1)
            done_tasks[r - children_count][4] = round(done_tasks[r - children_count][4] + total_cpu, 1)
            done_tasks[r - children_count][3] = children_count - 1
            done_tasks.append(i)

            total_mem = 0
            total_cpu = 0
            children_count = 1
            last_addition = False

        else:
            done_tasks.append(i)

        last_name = curr_name

    tasks_cleared = []
    # clearing list of shit
    for i in done_tasks:
        if i:
            tasks_cleared.append(i)

    # print(f"{tasks}\n{done_tasks}\n{time() - time1}")
    tasks = tasks_cleared

    # checking for needed tasks and deleting whenever its needed
    if needed_tasks:
        # clear out list by needed tasks
        tasks = sorted(tasks, key=sort_mem, reverse=True)
        if document:
            tasks_del = []
            for i in tasks:
                tasks_del.append(f"{i[0]}")
            tasks_del = "|".join(tasks_del)
            f = open("neededtasks.txt", "a")
            f.write(tasks_del)
            f.close()

        f = open("neededtasks.txt", "r")
        tasks_del = []
        file_read = f.read()
        f.close()
        file_read = file_read.split("|")
        for i in tasks:
            indispensable = False
            for t in file_read:
                if i[0] == t:
                    indispensable = True
                    break
            if not indispensable:
                tasks_del.append(i)
        return tasks_del

    # sorting output if asked for it
    else:
        if sort is not None:
            if sort == "Name":
                tasks = sorted(tasks, key=sort_name)
            elif sort == "Memory":
                tasks = sorted(tasks, key=sort_mem, reverse=True)
            elif sort == "PID":
                tasks = sorted(tasks, key=sort_pid)
            elif sort == "Children":
                tasks = sorted(tasks, key=sort_children, reverse=True)
            else:
                tasks = sorted(tasks, key=sort_cpu, reverse=True)
        return tasks

    # print(tasks_del)


def memory_checker(allowed_mem, killer, q, q1):
    global stop
    stop = False
    t = Thread(daemon=True, target=stop_input, args=(q, ))
    t.start()
    killed = True

    pid = getpid()
    ppid = getppid()

    # manage neededtasks.txt
    try:
        f = open("neededtasks.txt", "r")
        f.close()
    except FileNotFoundError:
        if "y" == input("\033[31mneededtasks.txt not found. Do you want to create it (every program open at "
                        "the Moment will be \033[32mImmune\033[31m to this program for ever)? (y/n)\033[0m: "):
            memory_sorter(True, False)
            print("neededtasks.txt created")
        else:
            print("canceled")
            if q1 != "":
                q1.put("")
            return

    print("RAMkill initiated. To stop RAMkill input \"ramkill-a\".")
    if q1 != "":
        q1.put("")

    while True:
        if stop:
            print("RAMkill closed \033[0m")
            break
        else:
            # killing highest process if memory percentage above allowed value
            if virtual_memory().percent >= allowed_mem and killed:
                killed = False
                pro = memory_sorter(True, False)
                # print(f"memory overload({allowed_mem}%), {killing} Name: {pro[0][0]}, RAM usage: {pro[0][1]}, PID: {pro[0][2]}.")
                for i in pro:
                    if killer:
                        if i[2] == pid or i[2] == ppid:
                            continue
                        cmd = f"taskkill -F -PID {i[2]}"
                        output = str(Popen(cmd, stdout=PIPE).communicate()[0])
                        if output.find("SUCCESS") != -1:
                            killed = True
                            print("\033[32m" + f"killed Process {i[0]}, memory: {i[1]}, PID: {i[2]} \033[0m")
                        if virtual_memory().percent <= allowed_mem:
                            print("memory below max allowed.")
                            break

                    else:
                        print(f"killing {i}")
            elif not killed:
                print("No kill, even though Memory use too high.")
                stop = True
                continue
            sleep(1)


if __name__ == '__main__':
    memory_sorter()
